
from gurobipy import *

# Create a new model
m = Model("Theta_Electronics")

# Define variables
R = m.addVar(name="Regular_Models", vtype=GRB.INTEGER, lb=0)
P = m.addVar(name="Premium_Models", vtype=GRB.INTEGER, lb=0)

# Set the objective function: Maximize profit
m.setObjective(200*R + 500*P, GRB.MAXIMIZE)

# Add constraints
m.addConstr(70*R + 100*P <= 6000, name="Assembly_Time_Constraint")
m.addConstr(25*R + 30*P <= 4000, name="Software_Verification_Time_Constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular Models: {R.x}")
    print(f"Premium Models: {P.x}")
    print(f"Maximum Profit: ${200*R.x + 500*P.x}")
else:
    print("No optimal solution found")
