
import gurobi as gp
from gurobi import GRB

# Create a new model
model = gp.Model("Theta_Electronics_Optimization")

# Define the decision variables
R = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Regular_Models")
P = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Premium_Models")

# Objective function: Maximize profit
model.setObjective(200*R + 500*P, GRB.MAXIMIZE)

# Assembly time constraint
model.addConstr(70*R + 100*P <= 6000, name="Assembly_Time_Constraint")

# Software verification time constraint
model.addConstr(25*R + 30*P <= 4000, name="Software_Verification_Time_Constraint")

# Optimize the model
model.optimize()

# Print the status of the optimization
print("Optimization Status: ", model.status)

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print("Regular Models: ", R.varValue)
    print("Premium Models: ", P.varValue)
    print("Max Profit: ", model.objVal)
else:
    print("The model is infeasible or unbounded.")
