
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Berry_Farming")

# Create variables
x = m.addVar(lb=0, name="local_farm_days")
y = m.addVar(lb=0, name="foreign_farm_days")

# Set objective function
m.setObjective(200*x + 500*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(2.5*x + 5*y >= 12, "raspberry_req")
m.addConstr(3*x + 4*y >= 10, "bilberry_req")
m.addConstr(2*x + 4*y >= 20, "strawberry_req")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Local Farm Days: {x.x:.2f}")
    print(f"Foreign Farm Days: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

