
from gurobipy import *

# Create a new model
m = Model("Berry Farm")

# Define the decision variables
x1 = m.addVar(name="local_farm_days", lb=0)
x2 = m.addVar(name="foreign_farm_days", lb=0)

# Define the objective function
m.setObjective(200*x1 + 500*x2, GRB.MINIMIZE)

# Define the constraints
m.addConstr(2.5*x1 + 5*x2 >= 12, name="raspberries")
m.addConstr(3*x1 + 4*x2 >= 10, name="bilberries")
m.addConstr(2*x1 + 4*x2 >= 20, name="strawberries")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Local farm days:", x1.x)
    print("Foreign farm days:", x2.x)
    print("Total cost:", m.objVal)
else:
    print("No optimal solution found")
