
import gurobi

def solve_berry_farm_problem():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    x_l = model.addVar(name="local_farm_days", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x_f = model.addVar(name="foreign_farm_days", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: minimize cost
    model.setObjective(200 * x_l + 500 * x_f, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2.5 * x_l + 5 * x_f >= 12, name="raspberries_constraint")
    model.addConstr(3 * x_l + 4 * x_f >= 10, name="bilberries_constraint")
    model.addConstr(2 * x_l + 4 * x_f >= 20, name="strawberries_constraint")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: ${model.objval:.2f}")
        print(f"Operate local farm for {x_l.varValue:.2f} days")
        print(f"Operate foreign farm for {x_f.varValue:.2f} days")
    else:
        print("No optimal solution found")

solve_berry_farm_problem()
