
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tin_production")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="tea_tins")  # Integer number of tea tins
y = m.addVar(vtype=GRB.INTEGER, name="coffee_tins") # Integer number of coffee tins

# Set objective
m.setObjective(11 * x + 13 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * x + 3 * y <= 500, "filling_time")
m.addConstr(x + 2 * y <= 600, "labeling_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of tea tins (x): {x.x}")
    print(f"Number of coffee tins (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

