
from gurobipy import *

# Create a new model
m = Model("Tea_and_Coffee")

# Define the decision variables
T = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Tea_Tins")
C = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Coffee_Tins")

# Set the objective function
m.setObjective(11*T + 13*C, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*T + 3*C <= 500, "Filling_Time")
m.addConstr(T + 2*C <= 600, "Labeling_Time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Tea Tins: {T.x}")
    print(f"Coffee Tins: {C.x}")
    print(f"Total Profit: ${11*T.x + 13*C.x:.2f}")
else:
    print("No optimal solution found")
