
import gurobi

def solve_tea_coffee_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    T = model.addVar(lb=0, name="T")  # Number of tea tins
    C = model.addVar(lb=0, name="C")  # Number of coffee tins

    # Objective function: Maximize profit
    model.setObjective(11*T + 13*C, gurobi.GRB.MAXIMIZE)

    # Filling time constraint
    model.addConstr(4*T + 3*C <= 500, name="Filling_Time")

    # Labeling time constraint
    model.addConstr(T + 2*C <= 600, name="Labeling_Time")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Tea tins: {T.varValue}, Coffee tins: {C.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible.")

# Run the function
solve_tea_coffee_problem()
