
import gurobipy as gp

# Create a new model
model = gp.Model("salad_optimization")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="caesar_salads")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="mediterranean_salads")

# Set objective function
model.setObjective(7*x + 9*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(100*x + 150*y <= 20000, "lettuce_constraint")
model.addConstr(10*x + 15*y <= 2000, "sauce_constraint")
model.addConstr(5*x + 15*y <= 3000, "cheese_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Caesar Salads: {x.x}")
    print(f"Number of Mediterranean Salads: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

