
from gurobipy import *

# Create a model
m = Model("Salad_Optimization")

# Decision Variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Caesar_Salads")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Mediterranean_Salads")

# Objective Function
m.setObjective(7*x + 9*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(100*x + 150*y <= 20000, "Lettuce_Constraint")
m.addConstr(10*x + 15*y <= 2000, "Sauce_Constraint")
m.addConstr(5*x + 15*y <= 3000, "Cheese_Constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Caesar Salads: {x.x}")
    print(f"Mediterranean Salads: {y.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
