
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="Caesar_salads")
y = model.addVar(lb=0, name="Mediterranean_salads")

# Define the objective function
model.setObjective(7 * x + 9 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(100 * x + 150 * y <= 20000, name="lettuce_constraint")
model.addConstr(10 * x + 15 * y <= 2000, name="sauce_constraint")
model.addConstr(5 * x + 15 * y <= 3000, name="cheese_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Caesar salads: {x.varValue}")
    print(f"Mediterranean salads: {y.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
