
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("museum_tickets")

# Create variables
g = m.addVar(lb=0, vtype=GRB.INTEGER, name="guided_tickets")
r = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_tickets")

# Set objective function
m.setObjective(50*g + 20*r, GRB.MAXIMIZE)

# Add constraints
m.addConstr(g + r <= 300, "total_tickets")
m.addConstr(g >= 50, "min_guided")
m.addConstr(r >= 3*g, "regular_preference")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Guided tickets: {g.x}")
    print(f"Regular tickets: {r.x}")
else:
    print("Infeasible or unbounded")

