
from gurobipy import *

# Create a new model
m = Model("Museum_Ticket_Sales")

# Define variables
G = m.addVar(name="Guided_Tickets", lb=0, vtype=GRB.CONTINUOUS)
R = m.addVar(name="Regular_Tickets", lb=0, vtype=GRB.CONTINUOUS)

# Set the objective function: Maximize profit
m.setObjective(50*G + 20*R, GRB.MAXIMIZE)

# Add constraints
m.addConstr(G + R <= 300, name="Total_Tickets")
m.addConstr(G >= 50, name="Min_Guided_Tickets")
m.addConstr(R >= 3*G, name="Regular_vs_Guided")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Guided Tickets: {G.x}")
    print(f"Regular Tickets: {R.x}")
    print(f"Total Profit: {m.ObjVal}")
else:
    print("No optimal solution found")
