
import gurobi

def solve_museum_ticket_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    G = model.addVar(lb=0, name="Guided_Tickets", vtype=gurobi.GRB.INTEGER)
    R = model.addVar(lb=0, name="Regular_Tickets", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(50*G + 20*R, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(G + R <= 300, name="Total_Tickets")
    model.addConstr(G >= 50, name="Min_Guided_Tickets")
    model.addConstr(R >= 3*G, name="Regular_vs_Guided")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Guided Tickets: {G.varValue}")
        print(f"Regular Tickets: {R.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_museum_ticket_problem()
