
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("plant_growth_compound")

# Create variables
x = m.addVar(lb=0, name="P100")
y = m.addVar(lb=0, name="Y200")

# Set objective function
m.setObjective(4*x + 6*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x + 9*y >= 200, "nitrogen")
m.addConstr(6*x + 10*y >= 150, "phosphoric_acid")
m.addConstr(5*x + 8*y <= 300, "vitamin_a")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  P100 (kg): {x.x}")
    print(f"  Y200 (kg): {y.x}")
    print(f"  Minimum Vitamin B: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

