
from gurobipy import *

# Create a new model
m = Model("Plant_Growth_Compound")

# Define the decision variables
x = m.addVar(name="P100", lb=0)  # Amount of P100 fertilizer
y = m.addVar(name="Y200", lb=0)  # Amount of Y200 fertilizer

# Set the objective function: minimize total vitamin B
m.setObjective(4*x + 6*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x + 9*y >= 200, name="Nitrogen_Requirement")
m.addConstr(6*x + 10*y >= 150, name="Phosphoric_Acid_Requirement")
m.addConstr(5*x + 8*y <= 300, name="Vitamin_A_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Minimum amount of vitamin B: {m.objVal}")
else:
    print("No optimal solution found")
