
import gurobi

def solve_fertilizer_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="P100", lb=0, ub=gurobi.GRB.INFINITY)
    y = model.addVar(name="Y200", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: Minimize vitamin B
    model.setObjective(4*x + 6*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(11*x + 9*y >= 200, name="Nitrogen")
    model.addConstr(6*x + 10*y >= 150, name="Phosphoric_Acid")
    model.addConstr(5*x + 8*y <= 300, name="Vitamin_A")

    # Optimize
    model.optimize()

    # Output
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal amount of P100: {x.varValue} kg")
        print(f"Optimal amount of Y200: {y.varValue} kg")
        print(f"Minimum amount of vitamin B: {4*x.varValue + 6*y.varValue} units")
    else:
        print("The problem is infeasible.")

solve_fertilizer_problem()
