
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("PieProduction")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="apple_pies")  # Integer since you can't make fractions of pies
y = model.addVar(vtype=GRB.INTEGER, name="blueberry_pies")

# Set objective function
model.setObjective(5*x + 6*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(30*x + 40*y <= 4500, "time_constraint")
model.addConstr(x <= 70, "apple_pie_limit")
model.addConstr(y <= 60, "blueberry_pie_limit")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of apple pies: {x.x}")
    print(f"Number of blueberry pies: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {model.status}")

