
from gurobipy import *

# Create a new model
m = Model("Pie_Making_Problem")

# Define variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="blueberry_pies")

# Set the objective function
m.setObjective(5*x + 6*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x + 40*y <= 4500, "time_constraint")
m.addConstr(x <= 70, "apple_pie_limit")
m.addConstr(y <= 60, "blueberry_pie_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Maximum profit: ${5*x.x + 6*y.x:.2f}")
else:
    print("No optimal solution found")
