
import gurobi

# Create a new model
m = gurobi.Model()

# Define the decision variables
x = m.addVar(lb=0, ub=70, name="apple_pies")
y = m.addVar(lb=0, ub=60, name="blueberry_pies")

# Define the objective function
m.setObjective(5 * x + 6 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(30 * x + 40 * y <= 4500, name="time_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Apple pies: {x.varValue}")
    print(f"Blueberry pies: {y.varValue}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found.")
