
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("auto_production")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cars")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="trucks")

# Set objective function
m.setObjective(5000 * x + 8000 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * x + 2.5 * y <= 800, "assembly_line")
m.addConstr(1 * x + 1.5 * y <= 600, "mechanic_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of cars to produce: {x.x}")
    print(f"Number of trucks to produce: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

