
from gurobipy import *

# Create a new model
m = Model("Auto_Production")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="cars", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="trucks", lb=0)

# Define the objective function: Maximize profit
m.setObjective(5000*x + 8000*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + 2.5*y <= 800, "assembly_line")
m.addConstr(x + 1.5*y <= 600, "mechanic_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x.x:.0f} cars and {y.x:.0f} trucks.")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
