
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
c = model.addVar(lb=0, name="cars")
t = model.addVar(lb=0, name="trucks")

# Define the objective function
model.setObjective(5000 * c + 8000 * t, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(2 * c + 2.5 * t <= 800, name="assembly_line_time")
model.addConstr(c + 1.5 * t <= 600, name="mechanic_time")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Cars to produce: {c.varValue}")
    print(f"Trucks to produce: {t.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found.")
