
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Restaurant_Optimization")

# Create decision variables
b = m.addVar(lb=0, vtype=GRB.INTEGER, name="burritos") # Integer number of burritos
s = m.addVar(lb=0, vtype=GRB.INTEGER, name="sandwiches") # Integer number of sandwiches


# Set objective function
m.setObjective(2.5 * b + 7 * s, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25 * b + 15 * s <= 5000, "pork_limit")
m.addConstr(s >= 4 * b, "sandwich_ratio")
m.addConstr(b >= 6, "min_burritos")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Burritos: {b.x}")
    print(f"Number of Sandwiches: {s.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

