
from gurobipy import *

# Create a model
m = Model("Pork_Meat_Optimization")

# Define variables
B = m.addVar(vtype=GRB.INTEGER, name="Burritos", lb=6)  # Number of burritos
S = m.addVar(vtype=GRB.INTEGER, name="Sandwiches")  # Number of sandwiches

# Objective function: Maximize profit
m.setObjective(2.5*B + 7*S, GRB.MAXIMIZE)

# Constraints
m.addConstr(25*B + 15*S <= 5000, "Pork_Meat_Limit")
m.addConstr(S >= 4*B, "Sandwich_to_Burrito_Ratio")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Burritos: {B.x}")
    print(f"Sandwiches: {S.x}")
    print(f"Maximum Profit: ${2.5*B.x + 7*S.x:.2f}")
else:
    print("No optimal solution found")
