
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(lb=0, name="Burritos")
    S = model.addVar(lb=0, name="Sandwiches")

    # Objective function: Maximize profit
    model.setObjective(2.5 * B + 7 * S, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(25 * B + 15 * S <= 5000, name="Pork_Meat_Constraint")
    model.addConstr(S >= 4 * B, name="Burrito_to_Sandwich_Ratio_Constraint")
    model.addConstr(B >= 6, name="Minimum_Burritos_Constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Burritos: {B.varValue}")
        print(f"Sandwiches: {S.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
