
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Mary's Diet")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="protein_drink")
y = m.addVar(vtype=GRB.CONTINUOUS, name="fruit_snack")

# Set objective function
m.setObjective(4*x + 12*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(45*x + 400*y >= 100, "Vitamin_A")
m.addConstr(200*x + 600*y >= 500, "Vitamin_C")
m.addConstr(300*x + 200*y >= 3000, "Protein")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Protein Drink Servings: {x.x:.2f}")
    print(f"Fruit Snack Servings: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

