
from gurobipy import *

# Create a new model
m = Model("Mary_Diet")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="ProteinDrink")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="FruitSnack")

# Set the objective function
m.setObjective(4*x1 + 12*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(45*x1 + 400*x2 >= 100, "VitaminA")
m.addConstr(200*x1 + 600*x2 >= 500, "VitaminC")
m.addConstr(300*x1 + 200*x2 >= 3000, "Proteins")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Servings of Protein Drink: {x1.x}")
    print(f"Servings of Fruit Snack: {x2.x}")
    print(f"Total Cost: ${4*x1.x + 12*x2.x:.2f}")
else:
    print("No optimal solution found.")
