
import gurobipy as gp

# Create a new model
m = gp.Model("Diet_Problem")

# Decision variables
x1 = m.addVar(name="protein_drink", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(name="fruit_snack", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: minimize cost
m.setObjective(4 * x1 + 12 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(45 * x1 + 400 * x2 >= 100, name="vitamin_A")
m.addConstr(200 * x1 + 600 * x2 >= 500, name="vitamin_C")
m.addConstr(300 * x1 + 200 * x2 >= 3000, name="proteins")

# Solve the model
m.solve()

# Output solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Servings of protein drink: {x1.varValue}")
    print(f"Servings of fruit snack: {x2.varValue}")
    print(f"Total cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
