
from gurobipy import Model, GRB

# Create a new model
m = Model("Gabriel's Farm")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pumpkins") # Acres of pumpkins
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="carrots")  # Acres of carrots

# Set objective function
m.setObjective(2.5 * x + 3.4 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "Land Availability")
m.addConstr(x >= 7, "Minimum Pumpkins")
m.addConstr(y >= 12, "Minimum Carrots")
m.addConstr(y <= 3 * x, "Carrot to Pumpkin Ratio")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Pumpkins: {x.x} acres")
    print(f"  Carrots: {y.x} acres")
    print(f"  Maximum Profit: ${m.objVal}")
else:
    print("No solution found.")

