
from gurobipy import *

# Create a model
m = Model("Gabriel_Farm")

# Define variables
P = m.addVar(vtype=GRB.CONTINUOUS, name="pumpkins", lb=0)
C = m.addVar(vtype=GRB.CONTINUOUS, name="carrots", lb=0)

# Set objective function to maximize profit
m.setObjective(2.5*P + 3.4*C, GRB.MAXIMIZE)

# Add constraints
m.addConstr(P >= 7, "min_pumpkins")
m.addConstr(C >= 12, "min_carrots")
m.addConstr(P + C <= 100, "total_land")
m.addConstr(C <= 3*P, "workforce_limitation")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pumpkins: {P.x} acres")
    print(f"Carrots: {C.x} acres")
else:
    print("No optimal solution found")

