
import gurobi

def solve_gabriel_farm_problem():
    # Create a new model
    model = gurobi.Model()

    # Variables
    P = model.addVar(lb=7, name="Pumpkins")  # Acres of pumpkins, minimum 7 acres
    C = model.addVar(lb=12, name="Carrots")  # Acres of carrots, minimum 12 acres

    # Objective function: Maximize profit
    model.setObjective(2.5 * P + 3.4 * C, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(P + C <= 100, name="Total_Acres")  # Total acres constraint
    model.addConstr(C <= 3 * P, name="Carrots_vs_Pumpkins")  # Carrots vs pumpkins constraint

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of pumpkins: {P.varValue}")
        print(f"Optimal acres of carrots: {C.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_gabriel_farm_problem()
