
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("PaintMixing")

# Create decision variables
x = model.addVar(lb=0, name="Iota")
y = model.addVar(lb=0, name="Lambda")

# Set objective function
model.setObjective(8*x + 12*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(3*x + 5*y >= 10, "Dye")
model.addConstr(5*x + 8*y >= 12, "Thinner")
model.addConstr(6*x + 3*y >= 15, "Oil")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal:.2f}")
    print(f"Iota Cans: {x.x:.2f}")
    print(f"Lambda Cans: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

