
import gurobi

def solve_paint_mixture_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="Iota", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="Lambda", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(8*x + 12*y, sense=gurobi.GRB.MINIMIZE)

    # Add the constraints
    model.addConstr(3*x + 5*y >= 10, name="Dye_Requirement")
    model.addConstr(5*x + 8*y >= 12, name="Thinner_Requirement")
    model.addConstr(6*x + 3*y >= 15, name="Oil_Requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Iota: {x.varValue}")
        print(f"Lambda: {y.varValue}")
        print(f"Minimum Cost: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_paint_mixture_problem()
