
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("shoe_production")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="black_shoes")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="blue_shoes")

# Set objective function
m.setObjective(-3*x + 6*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x <= 150, "black_shoe_capacity")
m.addConstr(y <= 100, "blue_shoe_capacity")
m.addConstr(x >= 75, "black_shoe_demand")
m.addConstr(y >= 60, "blue_shoe_demand")
m.addConstr(x + y >= 125, "total_shoes_shipped")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of black shoes to produce: {x.x}")
    print(f"Number of blue shoes to produce: {y.x}")
    print(f"Maximum profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

