
from gurobipy import *

# Create a new model
m = Model("Shoe Production")

# Define variables
B = m.addVar(lb=75, ub=150, name="Black_Shoes")  # Number of black shoes made daily
L = m.addVar(lb=60, ub=100, name="Blue_Shoes")   # Number of blue shoes made daily

# Objective function: Maximize net profits
m.setObjective(-3*B + 6*L, GRB.MAXIMIZE)

# Constraint: Minimum shipment requirement
m.addConstr(B + L >= 125, name="Minimum_Shipment")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Black Shoes: {B.x}")
    print(f"Blue Shoes: {L.x}")
    print(f"Total Profit: {-3*B.x + 6*L.x}")
else:
    print("No optimal solution found")
