
import gurobi

def solve_shoe_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(lb=0, ub=150, name="Black_Shoes")  # Black shoes
    L = model.addVar(lb=0, ub=100, name="Blue_Shoes")   # Blue shoes

    # Objective: Maximize net profit
    model.setObjective(6*L - 3*B, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(B >= 75, name="Min_Black_Demand")
    model.addConstr(L >= 60, name="Min_Blue_Demand")
    model.addConstr(B + L >= 125, name="Min_Total_Shoes")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal black shoes: {B.varValue}")
        print(f"Optimal blue shoes: {L.varValue}")
        print(f"Optimal net profit: {model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_shoe_problem()
