
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("VehicleProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="minivans")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="suvs")

# Set objective function
model.setObjective(5500*x + 4000*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(9*x + 7*y <= 450, "engineering_time")
model.addConstr(25*x + 25*y <= 1200, "steel")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Minivans: {x.x}")
    print(f"Number of SUVs: {y.x}")
    print(f"Optimal Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

