
from gurobipy import *

# Create a new model
m = Model("Vehicle_Production")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="minivans")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="SUVs")

# Set the objective function
m.setObjective(5500*x1 + 4000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(9*x1 + 7*x2 <= 450, "engineering_time")
m.addConstr(25*x1 + 25*x2 <= 1200, "steel")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Minivans: {x1.x}")
    print(f"SUVs: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
