
import gurobi

def solve_vehicle_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    x = model.addVar(name="minivans", lb=0, ub=gurobi.GRB.INFINITY)
    y = model.addVar(name="SUVs", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: Maximize profit
    model.setObjective(5500 * x + 4000 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(9 * x + 7 * y <= 450, name="engineering_time")
    model.addConstr(25 * x + 25 * y <= 1200, name="steel")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: Minivans = {x.varValue}, SUVs = {y.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible or unbounded.")

if __name__ == "__main__":
    solve_vehicle_production_problem()
