
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Tropical_Fruit_Optimization")

# Create decision variables
x = m.addVar(lb=0, name="Mango_Acres")
y = m.addVar(lb=0, name="Durian_Acres")

# Set objective function
m.setObjective(200*x + 300*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 150, "Land_Constraint")
m.addConstr(150*x + 180*y <= 20000, "Budget_Constraint")
m.addConstr(6*x + 3*y <= 700, "Labor_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of Mango trees")
    print(f"Plant {y.x:.2f} acres of Durian trees")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

