
from gurobipy import *

# Create a new model
model = Model("Lucas_Trees")

# Define variables
M = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Mango_Acres")
D = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Durian_Acres")

# Set the objective function: Maximize profit
model.setObjective(50*M + 120*D, GRB.MAXIMIZE)

# Add constraints
model.addConstr(150*M + 180*D <= 20000, "Budget_Constraint")
model.addConstr(6*M + 3*D <= 700, "Labor_Constraint")
model.addConstr(M + D <= 150, "Land_Availability")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: Plant {M.x:.2f} acres of mango trees and {D.x:.2f} acres of durian trees.")
    print(f"Maximum profit: ${model.ObjVal:.2f}")
else:
    print("No optimal solution found")
