
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    M = model.addVar(lb=0, name="Mango_Acres")
    D = model.addVar(lb=0, name="Durian_Acres")

    # Objective function: Maximize profit
    model.setObjective(200 * M + 300 * D, gurobi.GRB.MAXIMIZE)

    # Land constraint
    model.addConstr(M + D <= 150, name="Land_Constraint")

    # Budget constraint
    model.addConstr(150 * M + 180 * D <= 20000, name="Budget_Constraint")

    # Labor constraint
    model.addConstr(6 * M + 3 * D <= 700, name="Labor_Constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Mango Acres: {M.varValue}")
        print(f"Durian Acres: {D.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible.")

if __name__ == "__main__":
    solve_optimization_problem()
