
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("fast_food_optimization")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="burgers")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="sandwiches")

# Set objective function
m.setObjective(4.5 * x + 5 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 100, "min_burgers")
m.addConstr(y >= 80, "min_sandwiches")
m.addConstr(x <= 120, "max_burgers")
m.addConstr(y <= 100, "max_sandwiches")
m.addConstr(x + y <= 200, "total_items")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of burgers to sell: {x.x}")
    print(f"Number of sandwiches to sell: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {m.status}")

