
from gurobipy import *

# Create a model
m = Model("FastFoodOptimization")

# Define the decision variables
B = m.addVar(lb=100, ub=120, vtype=GRB.CONTINUOUS, name="burgers")
S = m.addVar(lb=80, ub=100, vtype=GRB.CONTINUOUS, name="sandwiches")

# Define the objective function
m.setObjective(4.5*B + 5*S, GRB.MAXIMIZE)

# Add constraints
m.addConstr(B + S <= 200, "total_items_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Burgers: {B.x}")
    print(f"Sandwiches: {S.x}")
    print(f"Maximum profit: ${4.5*B.x + 5*S.x:.2f}")
else:
    print("No optimal solution found")
