
import gurobi

def maximize_profit():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(lb=100, ub=120, name="Burgers")
    S = model.addVar(lb=80, ub=100, name="Sandwiches")

    # Objective function: Maximize profit
    model.setObjective(4.5 * B + 5 * S, gurobi.GRB.MAXIMIZE)

    # Additional constraint: Total items
    model.addConstr(B + S <= 200, name="Total_Items")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Burgers: {B.varValue}")
        print(f"Sandwiches: {S.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

maximize_profit()
