
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("plush_toy_production")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="bears") # Number of bears
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="dogs")  # Number of dogs

# Set objective function
m.setObjective(4*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x + 12*y <= 1000, "time_constraint")
m.addConstr(x >= 2*y, "demand_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of bears to produce: {x.x}")
    print(f"Number of dogs to produce: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No solution found or problem is infeasible.")

