
from gurobipy import *

# Create a new model
m = Model("plush_toys")

# Define variables
B = m.addVar(name="bears", vtype=GRB.INTEGER, lb=0)  # Number of bear plush toys
D = m.addVar(name="dogs", vtype=GRB.INTEGER, lb=0)   # Number of dog plush toys

# Set the objective function: Maximize profit
m.setObjective(4*B + 5*D, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*B + 12*D <= 1000, name="time_constraint")  # Time constraint
m.addConstr(B >= 2*D, name="production_ratio")            # Production ratio constraint

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bears: {B.x}")
    print(f"Dogs: {D.x}")
    print(f"Maximum Profit: ${4*B.x + 5*D.x}")
else:
    print("No optimal solution found")

