
import gurobi as gp

# Create a new model
m = gp.Model("Bear_Dog_Production")

# Define variables
B = m.addVar(name="Bears", vtype=gp.GRB.INTEGER, lb=0)
D = m.addVar(name="Dogs", vtype=gp.GRB.INTEGER, lb=0)

# Objective function: Maximize profit
m.setObjective(4 * B + 5 * D, sense=gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(15 * B + 12 * D <= 1000, name="Time_Constraint")
m.addConstr(B >= 2 * D, name="Bear_Dog_Constraint")

# Optimize
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Bears = {B.varValue}, Dogs = {D.varValue}")
    print(f"Max Profit: ${4 * B.varValue + 5 * D.varValue}")
else:
    print("No optimal solution found.")
