
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("steel_shop")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="fences")  # Number of fences
y = m.addVar(vtype=GRB.CONTINUOUS, name="doors")  # Number of doors

# Set objective function
m.setObjective(200*x + 100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + 5*y <= 400, "stainless_steel")
m.addConstr(10*x + y <= 500, "aluminum")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of fences to produce: {x.x}")
    print(f"Number of doors to produce: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

